#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200005;
const int SIZ = 32;

int A[MAXN];
int B[MAXN];
int prefs[MAXN];

unordered_map<int, int> mapi;

int sparse[SIZ][300000];

struct Node {
	int value = 0;
	int deca[2] = {-1, -1};
};
Node nodes[SIZ][MAXN];
int indexi[SIZ];

int newNode(int k) {
	indexi[k]++;
	nodes[k][indexi[k]].value = 0;
	nodes[k][indexi[k]].deca[0] = -1;
	nodes[k][indexi[k]].deca[1] = -1;
	return indexi[k];
}

void insert(int root, int k, int prefix) {
	int temp = root;

	for (int i = SIZ-1; i >= 0; i--) {
		bool bit = prefix & (1 << i);

		if (nodes[k][temp].deca[bit] == -1) {
			nodes[k][temp].deca[bit] = newNode(k);
		}
		temp = nodes[k][temp].deca[bit];
	}

	nodes[k][temp].value = prefix;
}

int queryAnti(int root, int k, int prefix) {
	int temp = root;

	for (int i = SIZ-1; i >= 0; i--) {
		bool bit = prefix & (1 << i);

		if (nodes[k][temp].deca[1-bit] != -1) {
			temp = nodes[k][temp].deca[1-bit];
		}
		else if (nodes[k][temp].deca[bit] != -1) {
			temp = nodes[k][temp].deca[bit];
		}
	}

	return mapi[nodes[k][temp].value];
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);

	int n;
	cin >> n;

	for (int i = 1; i <= n; i++) {
		cin >> A[i];
	}
	for (int i = 1; i <= n; i++) {
		cin >> B[i];
		sparse[0][i] = B[i];
	}

	for (int k = 1; (1<<k) < n; k++) {
		for (int i = 1; i <= n; i++) {
			sparse[k][i] = sparse[k-1][i] & sparse[k-1][i + (1 << (k-1))];
		}
	}

	// for (int k = 0; (1<<k) < n; k++) {
	// 	for (int i = 1; i <= n; i++) {
	// 		cout << sparse[k][i] << " ";
	// 	}
	// 	cout << endl;
	// }


	for (int k = 0; k < SIZ; k++) {
		indexi[k] = 0;
		newNode(k);
		insert(1, k, 0);
	}

	int prefix = 0;
	long long ans = LONG_LONG_MIN;
/*	for (int i = 0; i < n; i++) {
		prefix ^= A[i];
		insert(root, prefix);

		ans = max(ans, queryAnti(root, prefix));
	}
*/

	for (int i = 1; i <= n; i++) {
		prefix ^= A[i]; 
		prefs[i] = prefix;
		mapi[prefix] = i;
		for (int k = 0; k < SIZ; k++) {
			bool bit = B[i] & (1 << k);
			if (bit == false) {
				indexi[k] = 0;
				newNode(k);
				insert(1, k,  prefix);
			}


			else {
				insert(1, k, prefix);
			}
			int j = queryAnti(1, k, prefix);
			int valA = prefs[i] ^ prefs[j];

			int L = j+1;
			int R = i;
			int valB = 0;
			if (L == R) valB = B[L];
			else if (R > L) {
 				int stepen = (int)log2(R - L + 1); 
				valB = (sparse[stepen][L] & 
					sparse[stepen][R - (1 << stepen) + 1]);
			}
			long long temp = (long long)valA * valB;
			ans = max(ans, temp);

		}
	}

	cout << ans << endl;

	return 0;
}